/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class SortResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    public boolean distinct;
    public NoPutResultSet source;
    private GeneratedMethod closeCleanup;
    private GeneratedMethod rowAllocator;
    private ColumnOrdering[] order;
    private ColumnOrdering[] savedOrder;
    private SortObserver observer;
    private ExecRow sortTemplateRow;
    public boolean isInSortedOrder;
    private NoPutResultSet originalSource;
    private int maxRowSize;
    private ScanController scanController;
    private ExecRow sortResultRow;
    private ExecRow currSortedRow;
    private boolean nextCalled;
    private int numColumns;
    private long genericSortId;
    private boolean dropGenericSort;
    private boolean sorted;
    public Properties sortProperties = new Properties();
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$store$access$ColumnOrdering;

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.order = this.savedOrder;
        this.sortResultRow = this.sortTemplateRow.getClone();
        this.source.openCore();
        if (this.isInSortedOrder && this.distinct) {
            this.currSortedRow = this.getNextRowFromRS();
            if (this.currSortedRow != null) {
                this.currSortedRow = this.currSortedRow.getClone();
            }
        } else {
            this.scanController = this.loadSorter();
            this.sorted = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow execRow;
        boolean bl = this.order.length == 0 || this.isInSortedOrder;
        int n = (int)this.optimizerEstimatedRowCount;
        TransactionController transactionController = this.getTransactionController();
        long l = transactionController.createSort(null, this.sortTemplateRow.getRowArray(), this.order, this.observer, bl, n, this.maxRowSize);
        SortController sortController = transactionController.openSort(l);
        this.genericSortId = l;
        this.dropGenericSort = true;
        while ((execRow = this.getNextRowFromRS()) != null) {
            sortController.insert(execRow.getRowArray());
        }
        this.source.close();
        this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
        sortController.close();
        return transactionController.openSortScan(l, this.activation.getResultSetHoldability());
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isInSortedOrder && this.distinct) {
            if (this.currSortedRow == null) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return null;
            }
            if (!this.nextCalled) {
                this.nextCalled = true;
                this.numColumns = this.currSortedRow.getRowArray().length;
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                this.setCurrentRow(this.currSortedRow);
                return this.currSortedRow;
            }
            ExecRow execRow = this.getNextRowFromRS();
            while (execRow != null) {
                if (!this.filterRow(this.currSortedRow, execRow)) {
                    this.currSortedRow = execRow.getClone();
                    this.setCurrentRow(this.currSortedRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    ++this.rowsReturned;
                    return this.currSortedRow;
                }
                execRow = this.getNextRowFromRS();
            }
            this.currSortedRow = null;
            this.nextTime += this.getElapsedMillis(this.beginTime);
            return null;
        }
        ExecRow execRow = this.getNextRowFromRS();
        if (execRow != null) {
            this.setCurrentRow(execRow);
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private boolean filterRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n = 1;
        while (n <= this.numColumns) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(n);
            if (!dataValueDescriptor2.compare(2, dataValueDescriptor = execRow2.getColumn(n), true, true)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            this.sortResultRow = null;
            this.closeSource();
            if (this.dropGenericSort) {
                this.getTransactionController().dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.originalSource.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rowLocation = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rowLocation);
        return rowLocation;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    private ExecRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecRow getRowFromResultSet() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = this.source.getNextRowCore();
        if (execRow2 != null) {
            ++this.rowsInput;
            execRow = execRow2;
        }
        return execRow;
    }

    private ExecRow getRowFromSorter() throws StandardException {
        ExecRow execRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            execRow = this.sortResultRow;
            this.scanController.fetch(execRow.getRowArray());
        }
        return execRow;
    }

    private void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SortResultSet(NoPutResultSet noPutResultSet, boolean bl, boolean bl2, int n, Activation activation, GeneratedMethod generatedMethod, int n2, int n3, double d, double d2, GeneratedMethod generatedMethod2) throws StandardException {
        super(activation, n3, d, d2);
        this.distinct = bl;
        this.isInSortedOrder = bl2;
        this.source = noPutResultSet;
        this.originalSource = noPutResultSet;
        this.rowAllocator = generatedMethod;
        this.maxRowSize = n2;
        this.closeCleanup = generatedMethod2;
        this.sortTemplateRow = (ExecRow)this.rowAllocator.invoke(this.activation);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n)).getArray(class$Lorg$apache$derby$iapi$store$access$ColumnOrdering != null ? class$Lorg$apache$derby$iapi$store$access$ColumnOrdering : (class$Lorg$apache$derby$iapi$store$access$ColumnOrdering = SortResultSet.class$("org.apache.derby.iapi.store.access.ColumnOrdering")));
        this.savedOrder = this.order;
        this.observer = new BasicSortObserver(true, bl, this.sortTemplateRow, true);
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }
}

